IF  EXISTS (SELECT * FROM sys.objects 
            WHERE object_id = OBJECT_ID(N'[dbo].[UFD_DESCRICAO_DESC]') 
            AND type in (N'FN', N'WHEN', N'TF', N'FS', N'FT'))

/****** Object:  UserDefinedFunction [dbo].[UFD_DESCRICAO_DESC]    Script Date: 14/08/2013 16:42:21 ******/
DROP FUNCTION [dbo].[UFD_DESCRICAO_DESC]
GO

/****** Object:  UserDefinedFunction [dbo].[UFD_DESCRICAO_DESC]    Script Date: 14/08/2013 16:42:21 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE FUNCTION [dbo].[UFD_DESCRICAO_DESC]    (@INT_TP_DESCONTO			INT, 
											   @INT_CD_TBL_DESC   		INT, 
											   @INT_TP_NIVEL		    INT) 
	RETURNS VARCHAR(255) 
	 
	WITH SCHEMABINDING
	AS
BEGIN

-- SELECT * FROM dbo.UFD_DESCRICAO_DESC(1,3,1)

DECLARE @VAR_DESCONTO VARCHAR(255)

	SELECT 
		@VAR_DESCONTO = 
		
	CASE @INT_TP_DESCONTO
		WHEN 01 THEN 'Desconto produto'
		WHEN 03 THEN 'Desconto convenio'
		WHEN 04 THEN 'Desconto fidelidade'
		WHEN 06 THEN 'Desconto oferta'
		WHEN 11 THEN 'Desconto aniversrio'
		WHEN 12 THEN 'Desconto classWHENicao cliente'
		WHEN 13 THEN 'Desconto preo de fabrica'
		WHEN 14 THEN 'Desconto quantidade acima'
		WHEN 18 THEN 'Desconto forma de pagamento'
		WHEN 21 THEN 'Desconto convnio customizado'
		WHEN 23 THEN 'Desconto programado'
		WHEN 24 THEN 'Desconto leve e paga'		
		WHEN 19 THEN 'Desconto credirio'		
		WHEN 31 THEN 'Desconto Parceiro'				
		WHEN 28 THEN 'Desconto Cliente Especial'
		ELSE 'Sem desconto'
	END

	SELECT 
		@VAR_DESCONTO = @VAR_DESCONTO + 

	CASE @INT_TP_NIVEL
		WHEN 01 THEN '  nvel de produto'
		WHEN 02 THEN '  nvel de famlia'
		WHEN 03 THEN '  nvel de marca'
		WHEN 04 THEN '  nvel de fabricante'
		WHEN 05 THEN '  nvel de categoria'
		WHEN 06 THEN '  nvel de linha '
		ELSE ' sem definio de nivel'
	END
	
	IF @INT_CD_TBL_DESC > 0 
	BEGIN
		SET @VAR_DESCONTO = @VAR_DESCONTO + ' na tabela de desconto ' + CAST ( @INT_CD_TBL_DESC AS VARCHAR);
	END
	
	RETURN UPPER(@VAR_DESCONTO)
	
END